/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CTimerImpDrvNT.cpp,v 1.2 1999/12/22 10:05:05 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CTimerImpDrvNT.h"

_USING_PGP

// Class CTimerImpDrvNT member functions

CTimerImpDrvNT::~CTimerImpDrvNT()
{
	if (IsTimerRunning())
		StopTimer();
}

CComboError 
CTimerImpDrvNT::StartTimer(
	CTimer::CallbackFunc	timerCallback, 
	void					*userData, 
	PGPUInt32				msInterval, 
	PGPBoolean				isPeriodic)
{
	pgpAssert(!IsTimerRunning());
	pgpAssertAddrValid(timerCallback, CTimer::CallbackFunc);

	CComboError	error;

	mTimerCallback	= timerCallback;
	mUserData		= userData;
	mMsInterval		= msInterval;
	mIsPeriodic		= isPeriodic;

	LARGE_INTEGER	dueTime	= RtlConvertUlongToLargeInteger(
		-static_cast<PGPInt32>(
			msInterval * (PFLConstants::kHundredNsPerSec / 1000)));

	KeInitializeDpc(&mTimerDpc, TimerCallback, this);
	KeInitializeTimer(&mTimer);

	if (isPeriodic)
		KeSetTimerEx(&mTimer, dueTime, msInterval, &mTimerDpc);
	else
		KeSetTimerEx(&mTimer, dueTime, 0, &mTimerDpc);

	mIsTimerRunning = TRUE;
		
	return error;
}

void 
CTimerImpDrvNT::StopTimer()
{
	pgpAssert(IsTimerRunning());

	KeCancelTimer(&mTimer);

	mIsTimerRunning	= FALSE;
	mTimerCallback	= NULL;
	mUserData		= NULL;
}

void 
CTimerImpDrvNT::TimerCallbackAux()
{
	if (!IsPeriodic())
	{
		mIsTimerRunning = FALSE;
		mTimerCallback	= NULL;
		mUserData		= NULL;
	}

	mTimerCallback(mUserData);
}

VOID 
CTimerImpDrvNT::TimerCallback(
	PKDPC Dpc, 
	PVOID DeferredContext, 
	PVOID SystemArgument1, 
	PVOID SystemArgument2)
{
	CTimerImpDrvNT	*pImp	= static_cast<CTimerImpDrvNT *>(
		DeferredContext);
	pgpAssertAddrValid(pImp, CTimerImpDrvNT);

	pImp->TimerCallbackAux();
}
